import axios from 'axios'
import { Loading, Message } from 'element-ui'
let loadingInstance = null

// 白名单路径 - 这些请求不会显示loading (使用正则表达式匹配关键部分)
const WHITE_LIST = [
  /\/api\/cameras\/rgbd\/rgbd\/\d+\/current-frame/  // RGBD相机当前帧(带ID)
]

// 创建axios实例
const service = axios.create({
})

// 请求拦截器
service.interceptors.request.use(
  config => {
    // 检查请求是否匹配白名单中的任一正则
    const isInWhiteList = WHITE_LIST.some(regex => regex.test(config.url))
    
    // 不在白名单中的请求才显示loading
    if (!isInWhiteList) {
      loadingInstance = Loading.service({
        lock: true,
        text: '加载中...',
        background: 'rgba(0, 0, 0, 0.7)'
      })
    }

    return config
  },
  error => {
    // 关闭loading
    loadingInstance && loadingInstance.close()
    return Promise.reject(error)
  }
)

// 响应拦截器
service.interceptors.response.use(
  response => {
    loadingInstance && loadingInstance.close()
    
    const res = response.data
    if(res.code == 200){
      return res
    }else{
      Message.error(res.message)
      console.log(res.message)
    }
    // 可在此根据业务状态码处理不同情况
    // if (res.code !== 200) {
    //   Message.error(res.message || 'Error')
    //   return Promise.reject(new Error(res.message || 'Error'))
    // }
    
    return Promise.reject(res)
  },
  error => {
    // 关闭loading
    loadingInstance && loadingInstance.close()
    // console.log("123")
    // console.log(error)
    Message.error(error.message)
    // 可在此统一处理HTTP错误状态码
    // Message.error(error.message)
    
    return Promise.reject(error)
  }
)

export default service
