import Vue from 'vue'
import Vuex from 'vuex'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    patientInfo: {
      name: null,//姓名
      age: null,//年龄
      gender: null,//性别
      phone: null,//手机号
      idCard: null,//身份证号
      nativePlace: null,//籍贯
      height: 0,//身高
      weight: 0,//体重
      bookingId: null,//预约ID
      bkBkTime:null,//预约时间
    },
  },
  mutations: {
    SET_PATIENT_INFO(state, payload) {
      state.patientInfo = {...state.patientInfo, ...payload}
    },
    CLEAR_PATIENT_INFO(state) {
      state.patientInfo = {
        name: null,//姓名
        age: null,//年龄
        gender: null,//性别
        phone: null,//手机号
        idCard: null,//身份证号
        nativePlace: null,//籍贯
        height: null,//身高
        weight: null,//体重
        bookingId: null,//预约ID
        bkBkTime:null,//预约时间
      }
    }
  },
  actions: {
    updatePatientInfo({ commit }, patientData) {
      commit('SET_PATIENT_INFO', patientData)
    },
    clearPatient({ commit }) {
      commit('CLEAR_PATIENT_INFO')
    }
  },
  getters: {
    patientInfo: state => state.patientInfo,
    username: (state) => {
      let str = '';
      state.patientInfo.name ? str += state.patientInfo.name : str+='null';//姓名
      str+='-';
      state.patientInfo.age ? str += state.patientInfo.age : str+='null';//年龄
      str+='-';
      if(state.patientInfo.gender == 0){
        str += '男';
      }else if(state.patientInfo.gender == 1){
        str += '女';
      }else{
        str += 'null';
      }
      str+='-';
      state.patientInfo.phone ? str += state.patientInfo.phone : str+='null';//手机号
      str+='-';
      state.patientInfo.idCard ? str += state.patientInfo.idCard : str+='null';//身份证号
      str+='-';
      state.patientInfo.nativePlace ? str += state.patientInfo.nativePlace : str+='null';//籍贯
      return str;
    }
  }
})
