// cameraWorker.js
let socket = null;
let cameraId = null;

function connect(baseURL) {
  if (socket) {
    socket.close();
  }
  console.log("321",baseURL,cameraId)
  const wsUrl = `ws://${baseURL}/api/cameras/hd_static/ws/connect/${cameraId}`;
  socket = new WebSocket(wsUrl);

  socket.onopen = (event) => {
    postMessage({
      type: 'status',
      message: 'WebSocket已连接，等待相机响应...'
    });
  };

  socket.onmessage = (event) => {
    try {
      const data = JSON.parse(event.data);
      
      if (data.status) {
        postMessage({
          type: 'status',
          message: `连接成功: ${data.message}`
        });
        return;
      }

      if (data.error) {
        postMessage({
          type: 'error',
          message: data.error.includes('未初始化') 
            ? '请先在"相机控制"部分初始化相机，然后再尝试连接视频流'
            : data.error.includes('已在流式传输中')
              ? '相机正在使用中，请等待一会儿后再尝试连接'
              : `错误: ${data.error}`
        });
        return;
      }

      if (data.data) {
        // 转换base64为Blob
        const byteString = atob(data.data);
        const mimeType = 'image/jpeg';
        const ab = new ArrayBuffer(byteString.length);
        const ia = new Uint8Array(ab);
        for (let i = 0; i < byteString.length; i++) {
          ia[i] = byteString.charCodeAt(i);
        }
        const blob = new Blob([ab], { type: mimeType });
        
        postMessage({
          type: 'frame',
          blob,
          width: data.width,
          height: data.height,
          performance: data.performance,
          encode_time_ms: data.encode_time_ms,
          data_size_kb: data.data_size_kb
        });
      }
    } catch (error) {
      postMessage({
        type: 'error',
        message: `解析消息数据时出错: ${error}`
      });
    }
  };

  socket.onerror = (error) => {
    postMessage({
      type: 'error',
      message: `WebSocket连接错误：${error}`
    });
  };

  socket.onclose = (event) => {
    let closeReason = '';
    console.log(`websocket关闭:${event.code}`)
    switch (event.code) {
      case 1000: closeReason = '正常关闭'; break;
      case 1001: closeReason = '端点离开'; break;
      case 1002: closeReason = '协议错误'; break;
      case 1003: closeReason = '不支持的数据类型'; break;
      case 1006: closeReason = '异常关闭'; break;
      case 1011: closeReason = '服务器错误'; break;
      default: closeReason = `未知错误 (${event.code})`;
    }

    postMessage({
      type: 'status',
      message: `WebSocket连接已关闭: ${closeReason}`
    });
  };
}

function disconnect() {
  if (socket) {
    socket.close();
    socket = null;
  }
}


self.addEventListener('message', function(e) {
  const { action, id, baseURL } = e.data;
  console.log("123",action, id, baseURL)
  // 设置相机ID
  cameraId = id;
  switch (action) {
    case 'connect':
      connect(baseURL);
      break;
    case 'disconnect':
      disconnect();
      break;
  }
});