import request from '@/utils/request'
import { baseURLConsole1 } from '@/utils/url'
//获取动态拍摄高清相机列表
export function getDynamiCameraList() {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: '/api/cameras/hd_video/get_list',
    method: 'GET',
  })
}

//初始化指定的动态高清相机
export function initDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: '/api/cameras/hd_video/initialize',
    method: 'POST',
    data,
  })
}

//配置高清-视频采集相机参数
export function configDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/${data.camera_id}/set_orientation`,
    method: 'POST',
    data,
  })
}

//关闭指定的静态采集高清相机
export function closeDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: '/api/cameras/hd_video/close',
    method: 'POST',
    data
  })
}

//断开视频相机WebSocket连接
export function disconnectDynamiCamera(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/ws/disconnect/${camera_id}`,
    method: 'POST',
  })
}

//设置视频相机低帧率模式
export function lowDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/ws/fps/batch/set_ws_fps`,
    method: 'POST',
    data
  })
}

//动态视频拍摄相机同步视频采集
export function startDynamiCameraStart(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/multi_hd_video_recode/start`,
    method: 'POST',
    data
  })
}

//动态视频拍摄相机同步视频采集停止

export function stopDynamiCameraStart(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/multi_hd_video_recode/stop`,
    method: 'POST',
    data
  })
}
//获取动态相机的链接状态
export function getWebSocketLink(){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/ws/status`,
    method: 'GET',
  })
}

//双目相机和动态相机一键录制
export function startMultiCameraRecode(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/multi_control/multi_camera_recode/start`,
    method: 'POST',
    data
  })
}
//双目相机和动态相机一键停止
export function stopMultiCameraRecode(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/multi_control/multi_camera_recode/stop`,
    method: 'POST',
    data
  })
}

//设置相机亮度
export function setDynamiCameraBrightness(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/brightness`,
    method: 'PUT',
    data
  })
}
//设置相机对比度
export function setDynamiCameraContrast(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/contrast`,
    method: 'PUT',
    data
  })
}
//设置相机饱和度
export function setDynamiCameraSaturation(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/saturation`,
    method: 'PUT',
    data
  })
}
//设置相机色调
export function setDynamiCameraHue(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/hue`,
    method: 'PUT',
    data
  })
}
//设置相机图像增益
export function setDynamiCameraGain(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/gain`,
    method: 'PUT',
    data
  })
}
//设置相机曝光度
export function setDynamiCameraExposure(data){
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/hd_video/exposure`,
    method: 'PUT',
    data
  })
}
