import request from '@/utils/request'
import { baseURLConsole1 } from '@/utils/url'
//获取双目相机列表
export function getStereoCameraList() {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: '/api/cameras/rgbd/rgbd',
    method: 'GET',
  })
}

//初始化双目相机
export function initStereoCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: '/api/cameras/rgbd/rgbd/initialize',
    method: 'POST',
    data
  })
}

//关闭指定的双目相机
export function closeStereoCamera(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/${camera_id}/close`,
    method: 'POST',
  })
}

//获取双目相机当前帧
export function getStereoCameraFrame(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/${camera_id}/current-frame`,
    method: 'GET',
  })
}

//获取指定双目相机的录制状态
export function getStereoCameraRecordStatus(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/${camera_id}/recording-status`,
    method: 'GET',
  })
}

//开始双目相机录制
export function startStereoCameraRecording(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/start-recording`,
    method: 'POST',
    data
  })
}
//停止双目相机录制
export function stopStereoCameraRecording(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/${camera_id}/stop-recording`,
    method: 'POST',
  })
}

//设置相机曝光和增益参数
export function setStereoCameraExposureGain(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/set_rgbd_exposure_gain`,
    method: 'PUT',
    data
  })
}

//设置相机亮度
export function setStereoCameraBrightness(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/brightness`,
    method: 'PUT',
    data
  })
}

//设置相机对比度
export function setStereoCameraContrast(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/contrast`,
    method: 'PUT',
    data
  })
}

//设置相机色调
export function setStereoCameraHue(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/hue`,
    method: 'PUT',
    data
  })
}

//设置相机饱和度
export function setStereoCameraSaturation(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/saturation`,
    method: 'PUT',
    data
  })
}

//设置相机锐度
export function setStereoCameraSharpness(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/sharpness`,
    method: 'PUT',
    data
  })
}

//设置相机伽马
export function setStereoCameraGamma(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/gamma`,
    method: 'PUT',
    data
  })
}

//设置相机白平衡
export function setStereoCameraWhiteBalance(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/whitebalance`,
    method: 'PUT',
    data
  })
}

//设置相机分辨率
export function setStereoCameraResolution(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/resolution`,
    method: 'PUT',
    data
  })
}

//设置相机帧率
export function setStereoCameraFps(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/frame-rate`,
    method: 'PUT',
    data
  })
}

//设置相机深度开关
export function setStereoCameraDepthEnabled(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/depth-enabled`,
    method: 'PUT',
    data
  })
}

//设置相机深度模式
export function setStereoCameraDepthMode(data) {
  return request({
    baseURL:`http://${baseURLConsole1}`,
    url: `/api/cameras/rgbd/rgbd/depth-mode`,
    method: 'PUT',
    data
  })
}
