const { defineConfig } = require('@vue/cli-service')
module.exports = defineConfig({
  transpileDependencies: true,
  devServer:{
    client:{
      overlay: false
    }
  },
  chainWebpack(config) {
    // set worker-loader
    config.module
      .rule('worker')
      .test(/\.worker\.js$/)
      .use('worker-loader')
      .loader('worker-loader')
      .options({
        inline: 'fallback' // 添加这行
      })
      .end();

    // 解决：worker 热更新问题
    config.module.rule('js').exclude.add(/\.worker\.js$/);
    // 解决："window is undefined"报错
    config.output.globalObject('this');
  },
  parallel: false,
})
