function pad(timeEl, total = 2, str = '0') {
  return timeEl.toString().padStart(total, str)
}

export function timeProcessing(data) {
  let timer
  if(data){
    timer = new Date(data)
  }else{
    timer = new Date()
  }
  const year = timer.getFullYear()
  const month = timer.getMonth() + 1 // 由于月份从0开始，因此需加1
  const day = timer.getDate()
  const hour = timer.getHours()
  const minute = timer.getMinutes()
  const second = timer.getSeconds()
  return `${pad(year, 4)}-${pad(month)}-${pad(day)} ${pad(hour)}:${pad(minute)}:${pad(second)}`
}

//开始时间
export function startTimeProcessing(data) {
  let timer = new Date(data)
  const year = timer.getFullYear()
  const month = timer.getMonth() + 1 // 由于月份从0开始，因此需加1
  const day = timer.getDate()
  return `${pad(year, 4)}-${pad(month)}-${pad(day)} 00:00:00`
}

//结束时间
export function endTimeProcessing(data) {
  let timer = new Date(data)
  const year = timer.getFullYear()
  const month = timer.getMonth() + 1 // 由于月份从0开始，因此需加1
  const day = timer.getDate()
  return `${pad(year, 4)}-${pad(month)}-${pad(day)} 59:59:59`
}
