import request from '@/utils/request'
import { baseURLConsole } from '@/utils/url'

//获取静态拍摄高清相机列表
export function getStillCameraList() {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_static/get_list',
    method: 'GET',
  })
}


//初始化指定的静态高清相机
export function initializeStillCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_static/initialize',
    method: 'POST',
    data
  })
}
//配置静态采集高清相机参数
export function setStillCameraOrientation(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_static/set_orientation',
    method: 'POST',
    data
  })
}

//批量设置低帧率模式
export function lowStillCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_static/ws/fps/batch/set_ws_rate`,
    method: 'POST',
    data
  })
}

//关闭指定的静态采集高清相机
export function closeStillCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_static/close`,
    method: 'POST',
    data
  })
}

//捕获高清相机的单帧图像并保存
export function captureStillCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_static/capture`,
    method: 'POST',
    data
  })
}


//websocket断开链接清理后端状态
export function disconnectStillCamera(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_static/ws/disconnect/${camera_id}`,
    method: 'POST',
  })
}


//查询webSocket链接
export function getWebSocketLink() {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_static/ws/status',
    method: 'GET',
  })
}
