import request from '@/utils/request'
import { baseURLConsole } from '@/utils/url'
//获取动态拍摄高清相机列表
export function getDynamiCameraList() {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_video/get_list',
    method: 'GET',
  })
}

//初始化指定的动态高清相机
export function initDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_video/initialize',
    method: 'POST',
    data,
  })
}

//配置高清-视频采集相机参数
export function configDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_video/${data.camera_id}/set_orientation`,
    method: 'POST',
    data,
  })
}

//关闭指定的静态采集高清相机
export function closeDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: '/api/cameras/hd_video/close',
    method: 'POST',
    data
  })
}

//断开视频相机WebSocket连接
export function disconnectDynamiCamera(camera_id) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_video/ws/disconnect/${camera_id}`,
    method: 'POST',
  })
}

//设置视频相机低帧率模式
export function lowDynamiCamera(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_video/ws/fps/batch/set_ws_fps`,
    method: 'POST',
    data
  })
}

//动态视频拍摄相机同步视频采集
export function startDynamiCameraStart(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_video/multi_hd_video_recode/start`,
    method: 'POST',
    data
  })
}

//动态视频拍摄相机同步视频采集停止

export function stopDynamiCameraStart(data) {
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_video/multi_hd_video_recode/stop`,
    method: 'POST',
    data
  })
}
//获取动态相机的链接状态
export function getWebSocketLink(){
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/hd_video/ws/status`,
    method: 'GET',
  })
}

//双目相机和动态相机一键录制
export function startMultiCameraRecode(data){
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/multi_control/multi_camera_recode/start`,
    method: 'POST',
  })
}
//双目相机和动态相机一键停止
export function stopMultiCameraRecode(data){
  return request({
    baseURL:`http://${baseURLConsole}`,
    url: `/api/cameras/multi_control/multi_camera_recode/stop`,
    method: 'POST',
  })
}
