import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

import Layout from '@/layout'

/**
 * 定义组件名称和组件对象的map对象
*/
export const componentMap = {
  'layout': require('@/layout').default,

  'permission_menu': () => import('@/views/permission/menu').then(m=>m.default),

  'permission_role': () => import('@/views/permission/role').then(m=>m.default),
  

  'company_list':()=>import('@/views/company/index').then(m=>m.default),
  'company_add':()=>import('@/views/company/addcompany').then(m=>m.default),

  'personal_vue': ()=>import('@/views/personal/personal').then(m=>m.default),

  'staff_list':()=>import('@/views/staff/staffList').then(m=>m.default),
  'staff_add':()=>import('@/views/staff/addStaff').then(m=>m.default),
  'staff_updata':()=>import('@/views/staff/updataStaff').then(m=>m.default),

  'type_list':()=>import('@/views/type/typeList').then(m=>m.default),
  'type_add':()=>import('@/views/type/typeAdd').then(m=>m.default),
  'type_updata':()=>import('@/views/type/typeUpdata').then(m=>m.default),

  'project_list':()=>import('@/views/project/projectList').then(m=>m.default),
  'project_add':()=>import('@/views/project/projectAdd').then(m=>m.default),
  'project_updata':()=>import('@/views/project/projectUpdata').then(m=>m.default),

  'project_member_list':()=>import('@/views/project/member/memberList').then(m=>m.default),
  'project_member_updata':()=>import('@/views/project/member/memberUpdata').then(m=>m.default),

  'project_income_list':()=>import('@/views/project/income/incomeList').then(m=>m.default),
  'project_income_add':()=>import('@/views/project/income/incomeAdd').then(m=>m.default),
  'project_income_updata':()=>import('@/views/project/income/incomeUpdata').then(m=>m.default),

  'project_expend_list':()=>import('@/views/project/expend/expendList').then(m=>m.default),
  'project_expend_add':()=>import('@/views/project/expend/expendAdd').then(m=>m.default),
  'project_expend_updata':()=>import('@/views/project/expend/expendUpdata').then(m=>m.default),

  //报销单
  //'expense_list': () => import('@/views/expense/expenseList.vue').then(m => m.default),
  //负责项目列表
  'beresponsiblefor_List':()=>import('@/views/project/beresponsiblefor/beresponsibleforList').then(m => m.default),
  //参与项目列表
  'participatein_List':()=>import('@/views/project/participatein/participateinList').then(m => m.default),



  'reimbursement_list':()=>import('@/views/reimbursement/reimbursementList').then(m=>m.default),
  'reimbursement_add':()=>import('@/views/reimbursement/reimbursementAdd').then(m=>m.default),
  'reimbursement_updata':()=>import('@/views/reimbursement/reimbursementUpdata').then(m=>m.default),
  //'reimbursement_print':()=>import('@/views/reimbursement/reimbursementPrint').then(m=>m.default),


  'reimbursement_finance_list':()=>import('@/views/reimbursement/finance/financeList').then(m=>m.default),
  'reimbursement_headman_list':()=>import('@/views/reimbursement/headman/headmanList').then(m=>m.default),


  'businessTravel_list':()=>import('@/views/businessTravel/businessTravelList').then(m=>m.default),
  'businessTravel_add':()=>import('@/views/businessTravel/businessTravelAdd').then(m=>m.default),
  'businessTravel_updata':()=>import('@/views/businessTravel/businessTravelUpdata').then(m=>m.default),


  'businessTravel_finance_list':()=>import('@/views/businessTravel/finance/financeList').then(m=>m.default),
  'businessTravel_headman_list':()=>import('@/views/businessTravel/headman/headmanList').then(m=>m.default),

  'reimburtype_list': () => import('@/views/reimebursementItem/reimebursementItemList.vue').then(m => m.default),
  'reimebursementItem_Add': () => import('@/views/reimebursementItem/reimebursementItemAdd.vue').then(m => m.default),
  'reimebursementItem_Update': () => import('@/views/reimebursementItem/reimebursementItemUpdate.vue').then(m => m.default),


  'apply_businessTravel_list':()=>import('@/views/businessTravel/apply/applyBusinessTravelList').then(m=>m.default),
  'apply_businessTravel_add':()=>import('@/views/businessTravel/apply/applyBusinessTravelAdd').then(m=>m.default),
  'apply_businessTravel_updata':()=>import('@/views/businessTravel/apply/applyBusinessTravelUpdata').then(m=>m.default),

  'apply_businessTravel_finance_list':()=>import('@/views/businessTravel/apply/finance/financeList').then(m=>m.default),
  'apply_businessTravel_headman_list':()=>import('@/views/businessTravel/apply/headman/headmanList').then(m=>m.default),


}

/**
 * Note: sub-menu only appear when route children.length >= 1
 * Detail see: https://panjiachen.github.io/vue-element-admin-site/guide/essentials/router-and-nav.html
 *
 * hidden: true                   设置菜单是否隐藏（不显示在左边菜单，缺省false）
 * alwaysShow: true               设置在一级菜单上，是否总是显示，true表示总是显示
 *                                如果为false，一级菜单只会在有多个子菜单情况下才显示
 * redirect: noRedirect           如果设置成noRedirect，面包屑不会重定向
 * name:'router-name'             路由名称，必须设置，且唯一
 * meta : {
    roles: ['admin','editor']    允许路由的角色列表
    title: 'title'               显示在左边导航栏和面包屑上的名称
    icon: 'svg-name'/'el-icon-x' 图标名称
    noCache: true                页面是否不要缓存，缺省为false
    affix: true                  标签页面是否总是显示（不能关闭）
    breadcrumb: false            缺省true，是否以面包屑显示页面
    activeMenu: '/example/list'  在左边菜单上高亮显示
  }
 */

export const asyncRoutes=[

]
export const constantRoutes = [
  {
    path: '/login',
    component: () => import('@/views/login/index'),
    hidden: true
  },
  {
    path: '/404',
    component: () => import('@/views/error-page/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error-page/401'),
    hidden: true
  },
  //登录首页修改
  {
    path: '/',
    // hidden: true,
    component: Layout,
    redirect: '/personal',
   
  },
]



const createRouter = () => new Router({
  // mode: 'history', // require service support
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRoutes,asyncRoutes
})


const router = createRouter()
export function resetRouter() {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher // reset router
}

export default router
