import Vue from 'vue'

import 'normalize.css/normalize.css' // a modern alternative to CSS resets
import  Element from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import '@/styles/element-variables.scss'
import '@/styles/index.scss' // global css

import App from './App'  // 导入App第一个组件
import store from './store'
import router from './router'

import './icons' // icon
import './permission' // 导入权限控制脚本
import './utils/error-log' // error log

//import print from "print-js"//引入打印插件

import * as filters from './filters' // global filters

Vue.use(Element)

// if (process.env.NODE_ENV === 'production') {
//   const { mockXHR } = require('../mock')
//   mockXHR()
// }

Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})

Vue.config.productionTip = false

new Vue({
  el: '#app',
  router,
  store,
  render: h => h(App)
})
