import request from '@/utils/request' 


export function getMenuTree() {
  return request({
    url: '/menu/search/tree',
    method: 'post'
  })
}

export function addMenu(data) {
  return request({
    url: '/menu/addMenu',
    method: 'post',
    data
  })
}

export function editMenu(data) {
  return request({
    url: '/menu/update',
    method: 'post',
    data
  })
}

export function deleteMenu(id) {
  return request({
    url: `/menu/delete/${id}`,
    method: 'post',
  })
}
