import request from '@/utils/request'
import qs from 'qs'

export function getRoles(data) {
  return request({
    url: '/role/select',
    method: 'post',
    data
  })
}

export function selectAllByCompanyId(data) {
  return request({
    url: '/role/selectAllByCompanyId',
    method: 'post',
    data:qs.stringify(data)
  })
}
export function addRole(data) {
  return request({
    url: '/role/insert',
    method: 'post',
    data
  })
}

export function updateRole(data) {
  return request({
    url: `/role/update`,
    method: 'post',
    data
  })
}

export function updateRolePermssions(data) {
  return request({
    url: `/role/update/perms`,
    method: 'put',
    data
  })
}

export function deleteRole(id) {
  return request({
    url: `/role/delete/${id}`,
    method: 'post'
  })
}

//项目列表角色添加
export function insertBatch(data) {
  return request({
    url: '/ProjectMember/insertBatchMember',
    method: 'post',
    data
  })
}

//项目列表角色查询 /user/secletAllByRlid
export function secletAllByRlid(projectAdd) {
  return request({
    url: '/user/secletAllByRlid',
    method: 'post',
    data: qs.stringify(projectAdd)
  })
}