import { constantRoutes, componentMap } from '@/router'
import { getRoutes } from '@/api/auth'

/**
 * Use meta.role to determine if the current user has permission
 * @param roles
 * @param route
 */
function hasPermission(roles, route) {
  if (route.meta && route.meta.roles) {
      return roles.some(role => route.meta.roles.includes(role))
  } else {
    return true
  }
}

export function filterAsyncRoutes(routes, roles) {

  const res = []
  routes.forEach(route => {
    const tmp = { ...route }
    if (hasPermission(roles, tmp)) {
      if (tmp.children) {
        tmp.children = filterAsyncRoutes(tmp.children, roles)
      }
      res.push(tmp)
    }
  })
  return res
}

const state = {
  routes: [],
  addRoutes: []
}

const mutations = {
  SET_ROUTES: (state, routes) => {
    state.addRoutes = routes
    state.routes = constantRoutes.concat(routes)
  }
}

// 替换route对象中的component
function replaceComponent(comp){
  if(comp.component && typeof(comp.component)=='string'){
    comp.component = componentMap[comp.component];
  }
  if(comp.children && comp.children.length>0){
    for(let i=0;i<comp.children.length;i++){
      comp.children[i] = replaceComponent(comp.children[i]);
    }
  }
  return comp
}

const actions = {
  generateRoutes: async function({ commit }, roles) {
    // console.log(routes)
    // 从后台请求所有的路由信息
    let res = await getRoutes()
    // 定义一个变量，用来存放可以访问的路由表

    let dbAsyncRoutes = res.data;

    let myAsyncRoutes = dbAsyncRoutes.filter(curr => {
      if(curr.children == null || curr.children.length === 0){
        delete curr.children
      }
      return replaceComponent(curr);
    })

    let accessedRoutes
    // 判断当前的角色列表中，是否有包含admin
    // if (roles == 1) {
    //   // 所有路由都可以被访问，将ansyncRoutes改造成从数据库中获取
    //   accessedRoutes = myAsyncRoutes || []
    //   console.log(accessedRoutes)
    // } else {
      // 根据角色，过滤掉不能访问的路由表
      accessedRoutes = filterAsyncRoutes(myAsyncRoutes, roles)
    //}

    // commit
    commit('SET_ROUTES', accessedRoutes)
    // 成功返回
    // console.log(accessedRoutes)
    return accessedRoutes
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
