"use strict";

// convert string to array (typed, when possible)
// Stryker disable all : because this is a utility function that was copied
// from
// https://github.com/open-xml-templating/pizzip/blob/34a840553c604980859dc6d0dcd1f89b6e5527b3/es6/utf8.js#L33
// eslint-disable-next-line complexity
function string2buf(str) {
  var c,
      c2,
      mPos,
      i,
      bufLen = 0;
  var strLen = str.length; // count binary size

  for (mPos = 0; mPos < strLen; mPos++) {
    c = str.charCodeAt(mPos);

    if ((c & 0xfc00) === 0xd800 && mPos + 1 < strLen) {
      c2 = str.charCodeAt(mPos + 1);

      if ((c2 & 0xfc00) === 0xdc00) {
        c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
        mPos++;
      }
    }

    bufLen += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
  } // allocate buffer


  var buf = new Uint8Array(bufLen); // convert

  for (i = 0, mPos = 0; i < bufLen; mPos++) {
    c = str.charCodeAt(mPos);

    if ((c & 0xfc00) === 0xd800 && mPos + 1 < strLen) {
      c2 = str.charCodeAt(mPos + 1);

      if ((c2 & 0xfc00) === 0xdc00) {
        c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
        mPos++;
      }
    }

    if (c < 0x80) {
      /* one byte */
      buf[i++] = c;
    } else if (c < 0x800) {
      /* two bytes */
      buf[i++] = 0xc0 | c >>> 6;
      buf[i++] = 0x80 | c & 0x3f;
    } else if (c < 0x10000) {
      /* three bytes */
      buf[i++] = 0xe0 | c >>> 12;
      buf[i++] = 0x80 | c >>> 6 & 0x3f;
      buf[i++] = 0x80 | c & 0x3f;
    } else {
      /* four bytes */
      buf[i++] = 0xf0 | c >>> 18;
      buf[i++] = 0x80 | c >>> 12 & 0x3f;
      buf[i++] = 0x80 | c >>> 6 & 0x3f;
      buf[i++] = 0x80 | c & 0x3f;
    }
  }

  return buf;
} // Stryker restore all


function postrender(parts, options) {
  for (var i = 0, l = options.modules.length; i < l; i++) {
    var _module = options.modules[i];
    parts = _module.postrender(parts, options);
  }

  var fullLength = 0;
  var newParts = options.joinUncorrupt(parts, options);
  var longStr = "";
  var lenStr = 0;
  var maxCompact = 65536;
  var uintArrays = [];

  for (var _i = 0, len = newParts.length; _i < len; _i++) {
    var part = newParts[_i]; // This condition should be hit in the integration test at :
    // it("should not regress with long file (hit maxCompact value of 65536)", function () {
    // Stryker disable all : because this is an optimisation that won't make any tests fail

    if (part.length + lenStr > maxCompact) {
      var _arr = string2buf(longStr);

      fullLength += _arr.length;
      uintArrays.push(_arr);
      longStr = "";
    } // Stryker restore all


    longStr += part;
    lenStr += part.length;
    delete newParts[_i];
  }

  var arr = string2buf(longStr);
  fullLength += arr.length;
  uintArrays.push(arr);
  var array = new Uint8Array(fullLength);
  var j = 0; // Stryker disable all : because this is an optimisation that won't make any tests fail

  uintArrays.forEach(function (buf) {
    for (var _i2 = 0; _i2 < buf.length; ++_i2) {
      array[_i2 + j] = buf[_i2];
    }

    j += buf.length;
  }); // Stryker restore all

  return array;
}

module.exports = postrender;