import { checkPhone, money_valid as contractMoneyValid, number_valid } from "@/utils/myValidate"

export const contractNatures = ['普通合同', '框架合同', '补充协议', '其它合同']

export const addFormValidRules = {
    firstParty: [{required: true, message: '甲方签订人不能为空', trigger: 'blur'}],
    contractName: [{required: true, message: '合同名称不能为空', trigger: 'blur'}],
    // contractNature: this.$route.query.checkedContractNature,
    // contarctRemarks: [{required: true, message: '不能为空', trigger: 'blur'}],
    contractStartTime: [{required: true, message: '合同开始日期不能为空', trigger: 'blur'}],
    contractFirstParty: [{required: true, message: '客户名称(甲方)不能为空', trigger: 'blur'}],
    contractMoney: [{required: true, validator: contractMoneyValid, trigger: 'blur'}],
    contractNumber: [{required: true,validator: number_valid, trigger: ['change','blur']}],
    contractPaetyb: [{required: true, message: '合同乙方不能为空', trigger: 'blur'}],
    contractEndTime: [{required: true, message: '合同结束日期不能为空', trigger: 'blur'}],
    signingTime: [{required: true, message: '合同签订时间不能为空', trigger: 'blur'}],
    partybName: [{required: true, message: '乙方签订人不能为空', trigger: 'blur'}],
    tax: [{required: true, message: '是否含税不能为空', trigger: 'blur'}],
    taxPoint: [{required: true, validator: function(rule, value, callback){
        if(value === null || value === undefined || value === ''){
            callback(new Error('税点不能为空'))
        }else if(Number(value) === NaN || Number(value) < 0){
            callback(new Error('请输入正确格式'))
        }else{
            callback()
        }
    }, trigger: 'blur'}],
    typeId: [{required: true, message: '合同类型不能为空', trigger: 'change'}],
    safekeeping: [{required: true, message: '合同保管人不能为空', trigger: 'blur'}],
    firstPartyAddress: [{required: true, message: '客户联系地址不能为空', trigger: 'blur'}],
    preparedBy: [{required: true, message: '合同制定人不能为空', trigger: 'blur'}],
    contractParent: [{required: true, message: '母合同名称不能为空', trigger: 'change'}],
    firstPartyPhone: [
        { required: true, validator: checkPhone, trigger: ['change','blur'] },
    ],
    contractMoney: [
        {
            validator: contractMoneyValid, trigger: ['blur']
        }
    ]
}