/**
 * @param {string} url
 * @param {string} fileName
 */
  import { getFileUrl } from "@/api/companyFile";
  import axios from 'axios'
export const downloadPDFFile = function (url, fileName) {
    axios({
      method: 'get',
      url,
      responseType: 'blob'
    }).then((res) => {
      // console.log('headers', res.headers)
      // handle(res.data, fileName)
      if (!res.data) {
        return
      }
      let url = window.URL.createObjectURL(new Blob([res.data], { type: 'application/pdf' }))
      const a = document.createElement('a')
      a.style.display = 'none'
      a.download = fileName
      a.href = url
      a.click()
      if (document.body.contains(a)) {
        document.body.removeChild(a)
      }
    })
  }

export const previewPDF = async (filename) => {
    const a = document.createElement("a"); //创建一个<a></a>标签
    // a.href = url; // 给a标签的href属性值加上地址，注意，这里是绝对路径，不用加 点.
    a.href=(await getFileUrl(filename)).data 
    a.target = "_blank";
    a.style.display = "none"; // 障眼法藏起来a标签
    document.body.appendChild(a); // 将a标签追加到文档对象中
    a.click(); // 模拟点击了a标签，会触发a标签的href的读取，浏览器就会自动下载了
    a.remove(); // 一次性的，用完就删除a标签
}