import request from '@/utils/request.js'

// 展示数据
// /trip/selectByUserId 分页查询(查询本人)  post
export function queryBypage(data) {
    return request({
        url:'/trip/selectByUserId',
        method:'post',
        data
    })
}

// /trip/selectByHeadman 分页查询（小组长查询）  post
export function queryByheadman(data) {
    return request({
        url:'/trip/selectByHeadman',
        method:'post',
        data
    })
}

// /trip/selectByFinance 分页查询（财务人员查询）  post
export function queryBypagefinance(data) {
    return request({
        url:'/trip/selectByFinance',
        method:'post',
        data
    })
}


// 查询报销类别
// /Type/selectAll 查询类别（不带分页） post
// 传的值 companyId  typeCategory=0
export function selectTypeitem(data) {
    return request({
        url:'/Type/selectAll',
        method:'post',
        data
    })
}

// 查询项目列表
// /project/selectAll 查询项目列表(不分页) post
export function selectProjectitem(data) {
    return request({
        url:'/project/selectAll',
        method:'post',
        data
    })
}

// 添加随从人员
// /user/secletAllStaff 获取全部员工不带分页 post
export function selectProjectpeople(data) {
    return request({
        url:'/user/secletAllStaff',
        method:'post',
        data
    })
}

// 添加数据
// /trip/insert post
export function insert(data) {
    return request({
        url:'/trip/insert',
        method:'post',
        data
    })
}

// 添加随从人员 修改随从人员
// /tripPersonnel/insertBatch 添加和更改 post
export function insertId(data) {
    return request({
        url:'/tripPersonnel/insertBatch',
        method:'post',
        data
    })
}

// 查询随从人员
// /tripPersonnel/selectAll post
export function selectAll(data) {
    return request({
        url:'/tripPersonnel/selectAll',
        method:'post',
        data
    })
}

// 小组长审批
// /trip/headamApproval post
export function Approval(data) {
    return request({
        url:'/trip/headamApproval',
        method:'post',
        data
    })
}

// 财务审批
// /trip/financeApproval post
export function finApproval(data) {
    return request({
        url:'/trip/financeApproval',
        method:'post',
        data
    })
}

//撤回
export function reimbursementListid(tripId) {
    return request({
    url:`/trip/withdraw/${tripId}`,
    method: 'post'
    })
  }

// /trip/resubmit 重新提交.
export function resubmit(data) { 
    return request({
      //url: `/reimbursement/resubmit/${reimbursementId}`, 
      url:'/trip/resubmit',
      method: 'post',
      data
    })
  }

//   查看详情 /trip/selectByTripId post
export function selectByTripId(data) { 
    return request({
      //url: `/reimbursement/resubmit/${reimbursementId}`, 
      url:'/trip/selectByTripId',
      method: 'post',
      data
    })
  }

//  修改 /trip/update post
export function update(data) { 
    return request({
      //url: `/reimbursement/resubmit/${reimbursementId}`, 
      url:'/trip/update',
      method: 'post',
      data
    })
  }

// /invoice/updatesubmit 报销提交修改(添加发票)
export function Addinvoice(data) { 
    return request({
      //url: `/reimbursement/resubmit/${reimbursementId}`, 
      url:'/invoice/updatesubmit',
      method: 'post',
      data
    })
  }