import request from '@/utils/request'
//插入一条记录
export const insertPettyMoneyRecord = (data) => {
    return request({
        url: '/pettyCash/insert',
        method: 'post',
        data
    })
}

//再未被审批之前可以修改
export const updatePettyMoneyRecord = (data) => {
    return request({
        url: '/pettyCash/update',
        method: 'post',
        data
    })
}

//财务人员审批列表
export const selectCompanyPettyRecord = (data) => {
    return request({
        url: '/pettyCash/selectPagecompany',
        method: 'post',
        data
    })
}

//个人申请记录
export const selectSelfPettyRecord = (data) => {
    return request({
        url: '/pettyCash/selectPageuser',
        method: 'post',
        data
    })
}

//某条申请详细记录
export const selctByPettyId = (data) => {
    return request({
        url: '/pettyCash/selctByPettyId',
        method: 'post',
        data
    })
}

//未偿还的记录
export const selectUnrepay = (data) => { //未还款
    return request({
        url: '/pettyCash/selectUnapproved',
        method: 'post',
        data
    })
}

//同意审批
export const agreePetty = (data) => {
    return request({
        url: '/pettyCash/agree',
        method: 'post',
        data
    })
}

// 拒绝审批
export const rejectPetty = (data) => {
    return request({
        url: '/pettyCash/reject',
        method: 'post',
        data
    })
}

// 撤回审批
export const revokePetty = (data) => {
    return request({
        url: '/pettyCash/revoke',
        method: 'post',
        data
    })
}

/******还款********/



// 同意还款
export const agreeRepay = (data) => {
    return request({
        url: '/pettyRepayment/agree',
        method: 'post',
        data
    })
}

// 申请还款
export const repayMoney = (data) => {
    return request({
        url: '/pettyRepayment/insert',
        method: 'post',
        data
    })
}

// 查询还款记录
export const repayRecordsByPettyId = (data) => {
    return request({
        url: '/pettyRepayment/selectAllBypettyId',
        method: 'post',
        data
    })
}
// 驳回还款
export const rejectRepay = (data) => {
    return request({
        url: '/pettyRepayment/reject',
        method: 'post',
        data
    })
}

// 修改还款信息
export const updateRepay = (data) => {
    return request({
        url: '/pettyRepayment/update',
        method: 'post',
        data
    })
}