import request from '@/utils/request'

/************* 合同类型管理 ************/

// 合同类型
export function selectContractTypeList(data) {
  return request({
    url: '/contractType/queryBypage',
    method: 'post',
    data
  })
}
// 所有合同类型
export function selectAllContractTypeList(data) {
  return request({
    url: '/contractType/selectAll',
    method: 'post',
    data
  })
}

// 增加合同类型
export function addContractType(data) {
  return request({
    url: '/contractType/insertBatch',
    method: 'post',
    data
  })
}

// 更新合同类型
export function updateContractType(data) {
  return request({
    url: '/contractType/update',
    method: 'post',
    data
  })
}

// 更新合同类型状态
export function updateContractTypeState(data) {
  return request({
    url: '/contractType/updateBystate',
    method: 'post',
    data
  })
}

/************* 合同管理 ************/

// 获取合同列表
export function selectContractList(data) {
  return request({
    url: '/contract/queryBypage',
    method: 'post',
    data
  })
}

// 获取全部合同列表
export function selectAllContractList(data) {
  return request({
    url: '/contract/selectAll',
    method: 'post',
    data
  })
}
// 增加合同
export function addContract(data) {
  return request({
    url: '/contract/insert',
    method: 'post',
    data
  })
}

// 获取某一个合同
export function getContractById(data) {
  return request({
    url: '/contract/selectByContractId',
    method: 'post',
    data
  })
}

// 更新某一个合同
export function updateContract(data) {
  return request({
    url: '/contract/update',
    method: 'post',
    data
  })
}

// 删除某一个合同
export function deleteContract(data) {
  return request({
    url: '/contractFile/delete',
    method: 'post',
    data
  })
}

//获取合同中的合同文件
export function selectContractFiles(data) {
  return request({
    url: '/contractFile/selectByContractId',
    method: 'post',
    data
  })
}