import request from '@/utils/request'

export function getRoutes() {
  return request({
    url: '/auth/routes',
    method: 'get'
  })
}

export function getOperateMenuRoleId(mnName) {
  return request({
    url: `/role/search/${mnName}`,
    method: 'get'
  })
}

export function login(data) {
  return request({
    url: '/auth/login', // '/vue-element-admin/user/login',
    method: 'post',
    data
  })
}

export function getInfo(token) {
  return request({
    url: '/auth/info', // '/vue-element-admin/user/info',
    method: 'get',
  
  })
}

export function logout() {
  return request({
    url: '/auth/logout', //'/vue-element-admin/user/logout',
    method: 'post'
  })
}

