/**
 * @param {string} url
 * @param {string} fileName
 */
import axios from 'axios'
export const downloadPDFFile = function (url, fileName) {
    axios({
      method: 'get',
      url,
      responseType: 'blob'
    }).then((res) => {
      // console.log('headers', res.headers)
      // handle(res.data, fileName)
      if (!res.data) {
        return
      }
      let url = window.URL.createObjectURL(new Blob([res.data], { type: 'application/pdf' }))
      const a = document.createElement('a')
      a.style.display = 'none'
      a.download = fileName
      a.href = url
      a.click()
      if (document.body.contains(a)) {
        document.body.removeChild(a)
      }
    })
  }