const { defineConfig } = require('@vue/cli-service')
const path = require('path')

function resolve(dir) {
  return path.join(__dirname, dir)
}

module.exports = defineConfig({
  transpileDependencies: true,
  lintOnSave: false,
  productionSourceMap: false,
  devServer: {
    open: true,
    https: false,
    hot:true,
    host: '0.0.0.0',
    proxy: {
      "/api": {
        target: 'http://192.168.3.6:8000',//代理地址 凡是使用/api
        changeOrigin: true,//允许跨域请求
        secure: false,
        pathRewrite: { //重写路径 替换请求地址中的指定路径
          ['^/api']: '/' //将请求地址中的api替换为空
        }
      }
    },
    client: {
      overlay: false
    }
  },

  configureWebpack: {
    resolve: {
      alias: {
        '@': resolve('src')
      },
      fallback: { 
        path: require.resolve("path-browserify"),
        fs:false,
        crypto: false,
      },
    }
  },
  
  css:{
    loaderOptions:{
      sass:{
        additionalData:`@import "./src/assets/scss/style.scss";`
      }
    }
  }
})
