export function setCookie(name, value) {
  let date = new Date()
  date.setDate(date.getDate() + 1)
  document.cookie = name + '=' + value + ';expires=' + date
}

export function getCookie(name) {
  let reg = RegExp(name + '=([^;]+)')
  let arr = document.cookie.match(reg)
  if (arr) {
    return arr[1]
  } else {
    return ''
  }
}

export function delCookie(name) {
  setCookie(name, null, -1)
}
