import axios from 'axios'
import { Message } from 'element-ui'
import Vue from 'vue'

const service = axios.create({

})
axios.defaults.withCredentials = true;
service.interceptors.request.use(
  config => {
    // config.headers['X-CSRFToken'] =  "CTfoWmXPYGyEbN9Dm2sUcHe7cMafl33rOZx8jGvzKGRrxALz9if7o3qWoOmRKtgy"
    config.headers['X-CSRFToken'] =  sessionStorage.getItem("X-CSRFToken")
    // axios.defaults.headers['X-CSRFToken'] = sessionStorage.getItem("X-CSRFToken")

    return config
  },
  err => {
    return Promise.reject(err)
  }
)

service.interceptors.response.use(
  response => {
    const res = response
    if (res.status !== 200) {
      Message({
        message: res.response.data || 'Error',
        type: 'error',
        duration: 5 * 1000
      })
    } else {
      return res.data
    }
  },
  error => {
    Message({
      message: error.response.data,
      type: 'error',
      duration: 5 * 1000
    })
    return Promise.reject(error)
  }
)

export default service
