import Vue from 'vue'
import request from "@/utils/request";

export const PostData = (url, body) =>{
  return request({
    baseURL:Vue.prototype.baseUrl,
    url: url,
    method: 'post',
    data: body,
    dataType: "json",
   
  })
}

export const GetData = (url, ...body) =>{
  return request({
    baseURL:Vue.prototype.baseUrl,
    url: url,
    method: 'get',
    params:{...body[0]} ||null,
    dataType: "json",
  })
}

export const FileData = (obj, data) =>{
  return request({
    method: 'post',
    url: obj.action,
    data,
    headers: { 'Content-Type': 'multipart/form-data' },
    //timeout: 120000
  })
}

export const FTPData = (url)=>{
  return request({
    method:'get',
    // baseURL:"ftp://admin:123456@192.168.3.6:2121",
    url:url,
    data:"",
    responseType:'blob',
  })
}




